# WebAR-SDK Example

Create your own Surface tracking web app using the WebAR SDK. Visit [Blippar WebAR SDK Documentation](https://support.blippar.com/hc/en-us/categories/4407844755347-Blippar-WebAR-SDK-Documentation-) for more details.

Supports Android Chrome and iOS Safari.

## AFrame

| surface-tracking  | portal-webar | marker-tracking |
| ------------- | ------------- | ------------- |
| [Live Demo][surface-tracking-demo-url]  | [Live Demo][portal-webar-demo-url]  | [Live Demo][marker-tracking-demo-url]  |
|   |   | [Scan these Marker Images one at a time][marker-tracking-scan-images]  |
|![Demo][surface-tracking-demo-gif]  | ![Demo][portal-webar-demo-gif]  | ![Demo][marker-tracking-demo-gif]  |
|![QR Code][surface-tracking-qrcode]  | ![QR Code][portal-webar-qrcode]  | ![QR Code][marker-tracking-qrcode]  |

[surface-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/aframe/surface-tracking/index.html "Live Demo"
[surface-tracking-demo-gif]: https://github.com/blippar/webar-sdk-example/raw/main/assets/surface_tracking_demo.gif "Surface Tracking"
[surface-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/aframe-surface-tracking-qrcode.png "QR Code"

[portal-webar-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/aframe/portal-webar/index.html "Live Demo"
[portal-webar-demo-gif]: https://github.com/blippar/webar-sdk-example/raw/main/assets/portal_webar_demo.gif "Portal Webar"
[portal-webar-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/aframe-portal-webar-qrcode.png "QR Code"

[marker-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/aframe/marker-tracking/index.html "Live Demo"
[marker-tracking-demo-gif]: https://github.com/blippar/webar-sdk-example/raw/main/assets/marker_tracking_demo.gif "Marker Tracking"
[marker-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/aframe-marker-tracking-qrcode.png "QR Code"

[marker-tracking-scan-images]: https://github.com/blippar/webar-sdk-example/raw/main/aframe/marker-tracking/markers/

## BabylonJS

| Surface Tracking  | Marker Tracking |
| ------------- | ------------- |
| [Live Demo][bjs-surface-tracking-demo-url] | [Live Demo][bjs-marker-tracking-demo-url]  |
|   | [Scan these Marker Images one at a time][bjs-marker-tracking-scan-images]  |
|![Demo][bjs-surface-tracking-demo-img]  | ![Demo][bjs-marker-tracking-demo-img]  |
|![QR Code][bjs-surface-tracking-qrcode]  | ![QR Code][bjs-marker-tracking-qrcode]  |

[bjs-surface-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/babylon/surface-tracking/index.html "Live Demo"
[bjs-surface-tracking-demo-img]: https://github.com/blippar/webar-sdk-example/raw/main/assets/babylon_surface_tracking_demo.gif "Surface Tracking"
[bjs-surface-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/babylon-surface-tracking-qrcode.png "QR Code"

[bjs-marker-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/babylon/marker-tracking/index.html "Live Demo"
[bjs-marker-tracking-demo-img]: https://github.com/blippar/webar-sdk-example/raw/main/assets/babylon_marker_tracking_demo.gif "Marker Tracking"
[bjs-marker-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/babylon-marker-tracking-qrcode.png "QR Code"

[bjs-marker-tracking-scan-images]: https://github.com/blippar/webar-sdk-example/raw/main/aframe/marker-tracking/markers/

## Playcanvas

| Surface Tracking  | Marker Tracking |
| ------------- | ------------- |
| [Live Demo][pc-surface-tracking-demo-url] | [Live Demo][pc-marker-tracking-demo-url]  |
| [Fork Project][pc-surface-tracking-project-url] | [Fork Project][pc-marker-tracking-project-url]  |
| [Read more][pc-surface-tracking-read-more]| [Read more][pc-marker-tracking-read-more]|
|   | [Scan these Marker Images one at a time][pc-marker-tracking-scan-images]  |
|![Demo][pc-surface-tracking-demo-img]  | ![Demo][pc-marker-tracking-demo-img]  |
|![QR Code][pc-surface-tracking-qrcode]  | ![QR Code][pc-marker-tracking-qrcode]  |

[pc-surface-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/playcanvas/surface-tracking/index.html "Live Demo"
[pc-surface-tracking-project-url]: https://playcanvas.com/project/859355/overview/surface-tracking "Project Url"
[pc-surface-tracking-demo-img]: https://github.com/blippar/webar-sdk-example/raw/main/assets/playcanvas-surface-tracking.jpg "Surface Tracking"
[pc-surface-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/playcanvas-surface-tracking-qrcode.png "QR Code"
[pc-surface-tracking-read-more]: https://github.com/blippar/webar-sdk-example/blob/main/playcanvas/README.md#surface-tracking "Read more"

[pc-marker-tracking-demo-url]: https://webar-sdk.blippar.com/webar-sdk-example/v1.4.3/playcanvas/marker-tracking/index.html "Live Demo"
[pc-marker-tracking-project-url]: https://playcanvas.com/project/859368/overview/marker-tracking "Project Url"
[pc-marker-tracking-demo-img]: https://github.com/blippar/webar-sdk-example/raw/main/assets/playcanvas-marker-tracking.jpg "Marker Tracking"
[pc-marker-tracking-qrcode]: https://github.com/blippar/webar-sdk-example/raw/main/assets/playcanvas-marker-tracking-qrcode.png "QR Code"
[pc-marker-tracking-read-more]: https://github.com/blippar/webar-sdk-example/blob/main/playcanvas/README.md#marker-tracking "Read more"

[pc-marker-tracking-scan-images]: https://github.com/blippar/webar-sdk-example/raw/main/aframe/marker-tracking/markers/
